cc  FORTRAN77 code: Application, Section 11.8
cc  File: mtarest-2015.for
cc  Coded by Ruey S. Tsay with some minor modifications by JDG
cc
cc  This program is intended for nonlinear time series analysis.
cc  It estimates a multivariate TAR model.
cc
cc  Created on May 20, 1997 to analyze intraday data sets.
cc  Modified on July 7 so that each regime may have its own AR order.
cc
cc  Further modified on November 14, 1997 to allow for diferent component 
cc  model in each regime. The model is now very flexible.
cc
cc  The program estimates a threshold-regression model: threshold variable
cc  and its threshold must be given.
cc  input: dat(.,.) is the data matrix
cc         locy: the column number in dat(.,.) that gives the dependent var.
cc         locthr: column in which threshold variable is stored in dat(.,.)
cc         locx: columns where independent variables are located in dat(.,.).
cc         iorx: order of each independent variables
cc         ixlag: lags of each independent variables
cc         p: order of the dependent variable
cc         nx: number of exogeneous variables.
cc         inx: number of regressors due to exogeneous variables.
cc         (nst, nend): data span used in the program
cc 
cc  Example:
cc    nob, nvar, n_y, n_x, delay, nregime, loc_thr: 1095 4 2 2 0 2 4
cc    Data_file Name: ice4col.dat
cc    input data span (1 = yes): 0
cc    loc_y: 1 2
cc    loc_x: 3 4
cc    input    1 thresholds: -0.408638
cc    max-ar-order & max-exog-order: 15 3
cc    regime:            1  component of focus:            1
cc    AR order by components: 15 1
cc    #(lags) of the x-variables: 3 2
cc    input detailed lags of exog. vars? (1=y): 1
cc    lags of  1-th exo. var: 1 2 3
cc    lags of  2-th exo. var: 0 1
cc    regime:            1  component of focus:            2
cc    AR order by components: 9 14
cc    #(lags) of the x-variables: 3 2
cc    input detailed lags of exog. vars? (1=y): 1
cc    lags of  1-th exo. var: 1 2 3
cc    lags of  2-th exo. var: 0 1
cc    regime:            2  component of focus:            1
cc    AR order by components: 9 9
cc    #(lags) of the x-variables: 2 2
cc    input detailed lags of exog. vars? (1=y): 1
cc    lags of  1-th exo. var: 1 2
cc    lags of  2-th exo. var: 1 2
cc    regime:            2  component of focus:            2
cc    AR order by components: 2 9
cc    #(lags) of the x-variables: 2 2
cc    input detailed lags of exog. vars? (1=y): 1
cc    lags of  1-th exo. var: 1 2
cc    lags of  2-th exo. var: 1 2
cc    Overall AIC & BIC  0.16993094E+05  0.17375808E+05
cc    Output file: fort.17
cc    residuals in fort.16; std. residuals in fort.18
cccccccccccccc Current setting
c    max-variables = 5
cc   max-ar-p = 29
cc   max-obs = 10000
cc   max-number-parameters for each component = 50
cc
cc   Maximum number of regimes = 5
c
       parameter(maxn=10000,md=50,mk=5)
       real*8 xpx(md,md),xpy(md),xpxinv(md,md) 
       real*8 phi(md),y(maxn),dat(maxn,6), thr(5)
       real*8 resi(maxn,mk), res(maxn,mk), tem, chk
       real*8 x(maxn,md), rms(mk), ratio,std
       real*8 aic, bic, dlog, wk(md,md), rcov(mk,mk)
       real*8 stdres(maxn,mk), sigma(mk), tmp
c
       integer nob, p, ip, lagth, nreg, npts(5), inx
       integer locy(5), locthr, nx, ny, locx(5), nvar, i, j 
       integer iorx(5), ist, ia, ii, jj, it
       integer icnt, nst, nend, idx, iar(5)
       integer ixlag(15,5), morx, icom
c
       character nfile*30
c
       iout = 17
c
c---------- nob = # of observations; p = ar-order
c
       write(6,1)
    1  format(1x,'nob, nvar, n_y, n_x, delay, nregime, loc_thr: ',$)
       read(5,*)nob, nvar, ny, nx, lagth, nreg, locthr
       if(nob .le. 0)stop
       if(nob .gt. maxn)nob = maxn
       if(nvar .le. 0)nvar = 1
       if((ny+nx).gt.nvar)then
        print*,'Number of variables fails to match'
        stop
       endif
       if(nvar .gt. 5)then
        print*,'too many variables! (the maximum is 5)'
        stop
       endif
       if(lagth.lt.0)lagth = 0
       if(locthr.le.0)locthr = 1
c
       write(6,2)
    2  format(1x,'Data_file Name: ',$)
       read(5,3)nfile
    3  format(a30)
       open(unit=21,file=nfile,status='old')
       do 4 i = 1, nob
 4        read(21,*)(dat(i,j),j=1,nvar)
       close(21)
c
       write(6,401)
 401   format(1x,'input data span (1 = yes): ',$)
       read(5,*) ii
       if(ii.eq.1)then
        write(6,402)
        read(5,*) nst, nend
        if(nend.gt.nob) nend=nob
        if(nst.lt.1) nst = 1
        nob = nend-nst+1
        if(nst.eq.1)go to 415
        do 410 it=1, nob
         do 408 i=1, nvar
 408        dat(it,i) = dat(it-1+nst,i)
 410        continue
       endif
 402    format(1x,'data span (nst, nend): ',$)
 415    continue
c
       write(6,5)
 5     format(1x,'loc_y: ',$)
       read(5,*) (locy(i),i=1,ny)
c
       if(nx.gt.0)then
        write(6,7)
        read(5,*)(locx(i),i=1,nx)
       endif
 7      format(1x,'loc_x: ',$)
c
       if(nreg.gt.1)then 
c--------- input thresholds
         write(6,11) nreg-1
         read(5,*)(thr(i),i = 2, nreg)
       endif
        thr(1) = -9.9d10
        i = nreg+1
        thr(i) = 9.9d10
   11  format(1x,'input', i5,' thresholds: ',$)
c
       write(6,8)
 8     format(1x,'max-ar-order & max-exog-order: ',$)
       read(5,*) p, morx
       ist = max0(p,morx,lagth)+1
c
c-------- In what follows, perform estimation equation by equation & 
c-------- regime by regime.
c
       aic = 0.0d0
       bic = 0.0d0
c
      do 8000 ia=1, nreg
c
       do 7000 icom = 1, ny
c
         print*,'regime: ',ia,' component of focus: ',icom
         write(6,61) 
          read(5,*) (iar(it),it=1,ny)
 61     format(1x,'AR order by components: ',$)
c
       if(nx.gt.0)then
        write(6,9)
        read(5,*)(iorx(i),i=1,nx)
c------------------------- give the default lags of inde. vars.
        do 44 i=1, nx
         if(iorx(i).gt.15)then
          print*,'max[#(lags)] is 15. Reset to 15.'
          iorx(i) = 15
         endif
c
         do 42 j=1, iorx(i)
 42         ixlag(j,i) = j
 44         continue
c
        write(6,56)
        read(5,*) it
        if(it.eq.1)then
         do 54 i=1, nx
          write(6,57) i
          read(5,*)(ixlag(j,i),j=1,iorx(i))
          do 53 j=1, iorx(i)
           if(ixlag(j,i).lt.0)then
              print*,'negative order not allowed'
              stop
             endif
 53        continue
 54       continue
        endif
       endif
 9      format(1x,'#(lags) of the x-variables: ',$)
 56     format(1x,'input detailed lags of exog. vars? (1=y): ',$)
 57     format(1x,'lags of',i3,'-th exo. var: ',$)
c      
c----------------- inx = # of regressors from x's variables.
      inx = 0
      if(nx.gt.0)then
       do 17 i=1, nx
          inx = inx + iorx(i)
 17       continue
      endif
c
c------- including a constant term (ip = dimension of x-matrix)
       ip = 1+ inx
       do 18 i=1, ny
 18       ip = ip + iar(i)
       if(ip.gt.md)then
        print*,'dimension exceeds program specification'
        stop
       endif
c------------------- icnt: number of data points in this regime.
      icnt = 0
        do 100 it = ist, nob
         chk = dat(it-lagth,locthr)  
         if(chk.lt.thr(ia))go to 100
         if(chk.ge.thr(ia+1))go to 100
c------------- the observation is in the ia-th regime
         icnt = icnt+1
         y(icnt) = dat(it,locy(icom))
         x(icnt,1) = 1.0d0
         idx = 1
         do 32 jj=1, ny
          if(iar(jj).le.0)go to 32
           do 30 i=1, iar(jj)
             idx=idx+1
 30          x(icnt,idx) = dat(it-i,locy(jj))
 32        continue
c
        if(nx.gt.0)then
         do 50 ii=1, nx
          if(iorx(ii).gt.0)then
           do 40 jj=1, iorx(ii)
              idx=idx+1
 40           x(icnt,idx)=dat(it-ixlag(jj,ii),locx(ii))
          endif
 50      continue
        endif
c
 100    continue
c
        npts(ia) = icnt
        if(icnt.le.ip)then
         print*,'insufficient data points in the', ia,'-th regime'
         stop
        endif
c
       if(idx.ne.ip)then
        print*,'dimension error'
        stop
       endif
       call regr(y,x,maxn,md,ip,icnt,xpx,xpxinv,xpy,phi)
c
c----------residuals & residual variance for component ''icom''
       tmp = 0.0d0
       do 120 it=1, icnt
         tem = 0.0d0
         do 110 ii=1, ip
 110      tem = tem + phi(ii)*x(it,ii)
       tem = y(it)-tem
       resi(it,icom) = tem
       tmp = tmp + tem*tem
 120   continue
c
       write(iout,152) ia,npts(ia)
c
       rms(icom) = tmp/dfloat(icnt-ip)
       sigma(icom) = dsqrt(rms(icom))
c
        write(iout,301) icom
        do 150 ii=1, ip
         std = dsqrt(xpxinv(ii,ii)*rms(icom))
         ratio = phi(ii)/std
 150     write(iout,151) ii,phi(ii), std, ratio 
 300    continue
 151    format(1x,1i,4f10.5)
 301    format(1x,'component ', i3)
c
 152    format(1x,'Regime:',i4,' Nobs:',i5)
c
 7000   continue
c----------------- Residual covariance matrix (MLE-type and LS-type)
       do 200 i=1, ny
        do 190 j=1, i
         tem = 0.0d0
         do 180 it=1, icnt
 180        tem=tem+resi(it,i)*resi(it,j)
        rcov(i,j) = tem/dfloat(icnt-ip)
        rcov(j,i) = rcov(i,j)
        xpx(j,i) = tem/dfloat(icnt)
 190    xpx(i,j) = tem
 200    continue
c
       call detmtx(xpx,wk,md,ny,tem)
**
       tem = dlog(tem)*dfloat(icnt)
       write(iout,201) tem
       aic = aic + tem + 2.0d0*dfloat(ip*ny)
       bic = bic + tem + dlog(dfloat(icnt))*dfloat(ip*ny)
c
 201   format(1x,'(log(det)*nobs) = ',f16.6)
c
       write(iout,302)
       do 160 i=1, ny
 160      write(iout,153)(rcov(i,j),j=1,ny)
 153      format(1x,5f12.5)
 302     format(1x,'Residual cov-mtx: ')
c
c------ store residuals and standardized residuals
        icnt = 0
        do 500 it=ist, nob
         chk = dat(it-lagth,locthr)  
         if(chk.lt.thr(ia))go to 500
         if(chk.ge.thr(ia+1))go to 500
         icnt = icnt+1
         do 450 j=1, ny
            stdres(it,j) = resi(icnt,j)/sigma(j)
 450        res(it,j) = resi(icnt,j)
 500     continue
c
c--------------- return for another regime
 8000  continue
c
       write(iout,3002)(thr(i),i=2,nreg)
 3002  format(1x,'Thresholds: ',5f12.6)
       write(iout,3003)aic,bic
       write(6,3003)aic,bic
 3003  format(1x,'Overall AIC & BIC',2e16.8)
c
       print*,'Output file: fort.17'
c
       do 3100 it=ist, nob
          write(18,3101) (stdres(it,j),j=1,ny)
 3100     write(16,3101) (res(it,j),j=1,ny)
 3101     format(1x,5f10.6)
c
       print*,'residuals in fort.16; std. residuals in fort.18'
c
       stop
       end
ccccccccccccccccccccccccccccccccccccccccccc
      subroutine mtinv(a, da, kcomp,idim)
c**** 
      integer i,j,kcomp,idim,ii
      real*8 a(kcomp,kcomp), da(kcomp,kcomp)
      real*8 dpivot, pivot, deta, t

      deta = 1.0d0
c**** 
      if (idim .eq. 1) goto 600
      do 100 i = 1, idim
      do 100 j = 1, idim
  100 da(i,j) = a(i,j)
  120 do 500 i = 1, idim
      pivot = da(i,i)
c**** 
c**** DIVIDE PIVOT ROW BY PIVOT ELEMENT.
c**** 
      deta = deta * pivot
      da(i,i) = 1.0d0
      dpivot = pivot + 1.0d-25
      dpivot = da(i,i) / dpivot
      pivot = dpivot
      do 200 j = 1, idim
c**** 
c**** REDUCE NON-PIVOT ROWS
c****
  200 da(i,j) = da(i,j) * pivot
  210 do 500 ii = 1, idim
      if (ii .eq. i) goto 500
      t = da(ii,i)
      da(ii,i) = 0.0d0
      do 300 j = 1, idim
c****
  300 da(ii,j) = da(ii,j) - (da(i,j) * t)
  500 continue
      return 
  600 da(1,1) = deta / a(1,1)
      return 
      end
c****
c**** END OF 'MTINV'
c**** 
c*****************************************
       subroutine regr(y,x,maxn,md,ip,n,xpx,xpxinv,xpy,phi)
c
       real*8 y(*),x(maxn,md),xpx(md,md),xpy(*),phi(*)
       real*8 xpxinv(md,md), tem
c
       integer ip,n,i,j,it
c
       do 100 i=1, ip
        do 90 j = 1, i
         tem = 0.0d0
         do 80 it = 1, n
 80         tem=tem+x(it,i)*x(it,j)
         xpx(i,j) = tem
 90      xpx(j,i) = tem
 100     continue
c
        do 110 i=1, ip
         tem = 0.0d0
         do 105 it=1, n
 105       tem=tem+x(it,i)*y(it)
 110       xpy(i) = tem
c
        call mtinv(xpx,xpxinv,md,ip)
c
        do 150 i=1, ip
         tem = 0.0d0
         do 140 j = 1, ip
 140        tem=tem+xpxinv(i,j)*xpy(j)
 150        phi(i) = tem
c
        return
        end
ccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c*****************************************
       subroutine detmtx(a,wk,mx,k,det)
c
c---- This program computes the determinant of a covariance matrix.
c     It assumes that the variance of each variable is not close to zero.
c     The program transforms the mtx into an upper triangular one.
c
       real*8 a(mx,mx), det, tem, wk(mx,mx), crit
       integer mx, k, i, j, km1
c--------- wk(.,.) is a working area.
c
       if(k.eq.1)then
        det = a(1,1)
        return
       endif
c
       km1 = k-1
       crit = 1.0d-15
c
       do 10 i=1, k
        do 10 j=1, k
 10        wk(i,j) = a(i,j)
c
       do 50 i=1, km1
        if(dabs(a(i,i)).le.crit)then 
         det = 0.0d0
         return
        endif
        tem = wk(i+1,i)/a(i,i)
        do 40 j=i+1, k
 40       wk(i+1,j) = wk(i+1,j)-wk(i,j)*tem
 50      continue
c
       det = 1.0d0
       do 60 i=1, k
 60       det = det*wk(i,i)
c
cc       print*,'det = ', det
c
       return
       end
ccccccccccccccccccccccccccccccccccccccccccccccccccc
